class ProductsController < ApplicationController
  def find_all_products
    render :amf => Product.find(:all)
  end

  def update_products
    Product.transaction do
      Product.delete_all

      params[0].each do |param|
        product = Product.new

        product.id = param.id
        product.domain_id = param.domain_id
        product.code = param.code
        product.name_po = param.name_po
        product.motion = param.motion
        product.parent_id = param.parent_id
        product.lft = param.lft
        product.rgt = param.rgt
        product.type = param.type
        product.model_name = param.model_name
        product.table_name = param.table_name
        product.detail_model_name = param.detail_model_name
        product.detail_table_name = param.detail_table_name
        product.parent_succeeded = param.parent_succeeded
        product.pivot = param.pivot
        product.workflow_enabled = param.workflow_enabled
        product.workflow = param.workflow
        product.mail = param.mail
        product.mail_skip_auth = param.mail_skip_auth
        product.document = param.document
        product.document_name_method = param.document_name_method
        product.document_number_method = param.document_number_method
        product.document_content_method = param.document_content_method
        product.attachment = param.attachment
        product.search = param.search
        product.csv = param.csv
        product.initial_roleable_type = param.initial_roleable_type
        product.scope_roleable_type = param.scope_roleable_type
        product.workflow_body_method = param.workflow_body_method
        product.permission_enabled = param.permission_enabled

        product.save
      end
    end
  end
end
